/*
 * Decompiled with CFR 0.152.
 */
package org.cte.ABCD.printer;

import java.util.IdentityHashMap;
import java.util.Map;
import org.cte.ABCD.ABCDVisitor;
import org.cte.ABCD.model.declarations.ABCDSystem;
import org.cte.ABCD.model.declarations.ArgumentMap;
import org.cte.ABCD.model.declarations.Asynchronous;
import org.cte.ABCD.model.declarations.ChannelDecl;
import org.cte.ABCD.model.declarations.ChannelTypeDecl;
import org.cte.ABCD.model.declarations.ConstantDecl;
import org.cte.ABCD.model.declarations.EventPool;
import org.cte.ABCD.model.declarations.Field;
import org.cte.ABCD.model.declarations.FunctionDecl;
import org.cte.ABCD.model.declarations.ParameterDecl;
import org.cte.ABCD.model.declarations.Port;
import org.cte.ABCD.model.declarations.PortMap;
import org.cte.ABCD.model.declarations.ProcessDecl;
import org.cte.ABCD.model.declarations.ProcessInstance;
import org.cte.ABCD.model.declarations.State;
import org.cte.ABCD.model.declarations.Synchronous;
import org.cte.ABCD.model.declarations.TypeDecl;
import org.cte.ABCD.model.declarations.VariableDecl;
import org.cte.ABCD.model.expressions.Any;
import org.cte.ABCD.model.expressions.ArrayLit;
import org.cte.ABCD.model.expressions.BinaryExp;
import org.cte.ABCD.model.expressions.FalseLit;
import org.cte.ABCD.model.expressions.FieldLiteral;
import org.cte.ABCD.model.expressions.FunctionCall;
import org.cte.ABCD.model.expressions.IndexedExp;
import org.cte.ABCD.model.expressions.IntegerLit;
import org.cte.ABCD.model.expressions.QueueLit;
import org.cte.ABCD.model.expressions.RecordLit;
import org.cte.ABCD.model.expressions.Reference;
import org.cte.ABCD.model.expressions.SelectedExp;
import org.cte.ABCD.model.expressions.TrueLit;
import org.cte.ABCD.model.expressions.UnaryExp;
import org.cte.ABCD.model.expressions.UnionLiteral;
import org.cte.ABCD.model.kernel.Declaration;
import org.cte.ABCD.model.kernel.Expression;
import org.cte.ABCD.model.kernel.Statement;
import org.cte.ABCD.model.statements.AssignStmt;
import org.cte.ABCD.model.statements.Block;
import org.cte.ABCD.model.statements.CaseItem;
import org.cte.ABCD.model.statements.CaseStmt;
import org.cte.ABCD.model.statements.DeferredEvent;
import org.cte.ABCD.model.statements.ForeachStmt;
import org.cte.ABCD.model.statements.GuardStmt;
import org.cte.ABCD.model.statements.IfStmt;
import org.cte.ABCD.model.statements.InputStmt;
import org.cte.ABCD.model.statements.LoopStmt;
import org.cte.ABCD.model.statements.NullStmt;
import org.cte.ABCD.model.statements.OutputStmt;
import org.cte.ABCD.model.statements.ReceiveStmt;
import org.cte.ABCD.model.statements.ReturnStmt;
import org.cte.ABCD.model.statements.SelectStmt;
import org.cte.ABCD.model.statements.SendStmt;
import org.cte.ABCD.model.statements.SpecialTypeStmt;
import org.cte.ABCD.model.statements.ToStmt;
import org.cte.ABCD.model.statements.Transition;
import org.cte.ABCD.model.statements.WaitStmt;
import org.cte.ABCD.model.statements.WhileStmt;
import org.cte.ABCD.model.types.Array;
import org.cte.ABCD.model.types.BoolType;
import org.cte.ABCD.model.types.IntType;
import org.cte.ABCD.model.types.Interval;
import org.cte.ABCD.model.types.MutexType;
import org.cte.ABCD.model.types.NatType;
import org.cte.ABCD.model.types.NoneType;
import org.cte.ABCD.model.types.Queue;
import org.cte.ABCD.model.types.Record;
import org.cte.ABCD.model.types.SemaphoreType;
import org.cte.ABCD.model.types.TimerType;
import org.cte.ABCD.model.types.Union;

public class PrintVisitor
implements ABCDVisitor {
    private StringBuilder sB = new StringBuilder();
    private Map<Object, String> visited = new IdentityHashMap<Object, String>();
    private int indentation = 0;

    public StringBuilder getsB() {
        return this.sB;
    }

    public void setsB(StringBuilder sB) {
        this.sB = sB;
    }

    private PrintVisitor cr() {
        this.sB.append("\n");
        return this;
    }

    private PrintVisitor tab() {
        ++this.indentation;
        return this;
    }

    private PrintVisitor untab() {
        --this.indentation;
        return this;
    }

    private PrintVisitor appendTabbed(String s) {
        for (int i = 0; i < this.indentation; ++i) {
            this.sB.append("\t");
        }
        this.sB.append(s);
        return this;
    }

    private PrintVisitor append(String s) {
        this.sB.append(s);
        return this;
    }

    public static String print(Statement stm) {
        PrintVisitor printer = new PrintVisitor();
        stm.accept(printer);
        return printer.getsB().toString();
    }

    @Override
    public void visitBoolType(BoolType toVisit) {
        this.append("bool");
    }

    @Override
    public void visitNatType(NatType toVisit) {
        this.append("nat");
    }

    @Override
    public void visitIntType(IntType toVisit) {
        this.append("int");
    }

    @Override
    public void visitNoneType(NoneType toVisit) {
        this.append("none");
    }

    @Override
    public void visitTimerType(TimerType toVisit) {
        this.append("timer");
    }

    @Override
    public void visitSemaphoreType(SemaphoreType toVisit) {
        this.append("semaphore");
    }

    @Override
    public void visitMutexType(MutexType toVisit) {
        this.append("mutex");
    }

    @Override
    public void visitInterval(Interval toVisit) {
        toVisit.getMini().accept(this);
        this.append("..");
        toVisit.getMaxi().accept(this);
    }

    @Override
    public void visitUnion(Union toVisit) {
        int i = 0;
        int size = toVisit.getFieldsCount();
        this.append("union").cr();
        this.indentation = 2;
        for (Field f : toVisit.getFieldsList()) {
            f.accept(this);
            this.cr();
            this.indentation = 2;
            if (++i != size) {
                this.appendTabbed("|");
            }
            this.indentation = 0;
        }
        this.indentation = 1;
        this.appendTabbed("end union").untab();
    }

    @Override
    public void visitUnionLiteral(UnionLiteral toVisit) {
        if (toVisit.getTypeName() != null) {
            this.append(toVisit.getTypeName() + ":");
            this.append(toVisit.getSelector());
        }
        if (toVisit.getExpression() != null) {
            this.append("(");
            toVisit.getExpression().accept(this);
            this.append(")");
        }
    }

    @Override
    public void visitRecord(Record toVisit) {
        this.append("record").cr().tab().tab();
        for (Field f : toVisit.getFieldsList()) {
            f.accept(this);
            this.append(",").cr();
        }
        this.untab().appendTabbed("end record").untab();
    }

    @Override
    public void visitField(Field toVisit) {
        this.appendTabbed(toVisit.getName());
        if (toVisit.getType() != null) {
            this.append(toVisit.getParent() instanceof Union ? " of " : " : ");
            toVisit.getType().accept(this);
        }
    }

    @Override
    public void visitArray(Array toVisit) {
        this.sB.append("array ");
        toVisit.getSize().accept(this);
        this.sB.append(" of ");
        toVisit.getType().accept(this);
    }

    @Override
    public void visitQueue(Queue toVisit) {
        this.sB.append("queue ");
        toVisit.getSize().accept(this);
        this.sB.append(" of ");
        toVisit.getType().accept(this);
    }

    @Override
    public void visitTypeDecl(TypeDecl toVisit) {
        String str = this.visited.get(toVisit);
        if (str != null) {
            this.sB.append(str);
            return;
        }
        this.sB.append("type " + toVisit.getName() + " is ");
        toVisit.getType().accept(this);
        this.sB.append("\n");
        this.visited.put(toVisit, toVisit.getName());
    }

    @Override
    public void visitSynchronous(Synchronous toVisit) {
        this.append("sync");
    }

    @Override
    public void visitAsynchronous(Asynchronous toVisit) {
        this.append("async");
        if (toVisit.isIsBlocking()) {
            this.append(" block ");
        } else {
            this.append(" noblock ");
        }
        this.append("buffersize: ");
        toVisit.getSize().accept(this);
    }

    @Override
    public void visitChannelTypeDecl(ChannelTypeDecl toVisit) {
        String str = this.visited.get(toVisit);
        if (str != null) {
            this.sB.append(str);
            return;
        }
        this.sB.append("channeltype " + toVisit.getName() + " is ");
        toVisit.getSynchronizationPolicy().accept(this);
        this.sB.append(" of ");
        toVisit.getType().accept(this);
        this.sB.append("\n");
        this.visited.put(toVisit, toVisit.getName());
    }

    @Override
    public void visitConstantDecl(ConstantDecl toVisit) {
        String str = this.visited.get(toVisit);
        if (str != null) {
            this.append(str);
            return;
        }
        this.append("const " + toVisit.getName() + " : ");
        toVisit.getType().accept(this);
        this.append(" is ");
        toVisit.getValue().accept(this);
        this.cr();
        this.visited.put(toVisit, toVisit.getName());
    }

    @Override
    public void visitVariableDecl(VariableDecl toVisit) {
        String str = this.visited.get(toVisit);
        if (str != null) {
            this.append(str);
            return;
        }
        this.cr();
        this.appendTabbed((toVisit.isIsLTT() ? "LTT" : "") + toVisit.getName() + " : ");
        toVisit.getType().accept(this);
        if (toVisit.getValue() != null) {
            this.append(" := ");
            toVisit.getValue().accept(this);
        }
        this.visited.put(toVisit, toVisit.getName());
    }

    @Override
    public void visitChannelDecl(ChannelDecl toVisit) {
        String str = this.visited.get(toVisit);
        if (str != null) {
            this.append(str);
            return;
        }
        this.append("channel " + toVisit.getName() + " : ");
        toVisit.getType().accept(this);
        this.cr();
        this.visited.put(toVisit, toVisit.getName());
    }

    @Override
    public void visitPort(Port toVisit) {
        this.appendTabbed(toVisit.getName() + " : " + (toVisit.isIsInput() ? "in " : "out "));
        toVisit.getType().accept(this);
    }

    @Override
    public void visitProcessDecl(ProcessDecl toVisit) {
        this.append("process " + toVisit.getName());
        this.cr();
        this.tab();
        if (toVisit.getPortsCount() > 0) {
            this.appendTabbed("port");
            this.cr();
            this.tab();
            for (Port port : toVisit.getPortsList()) {
                port.accept(this);
                this.append(";\n");
            }
            this.untab();
        }
        if (toVisit.getParametersCount() > 0) {
            this.appendTabbed("param");
            this.tab();
            for (ParameterDecl parameterDecl : toVisit.getParametersList()) {
                parameterDecl.accept(this);
                this.append(";");
            }
            this.untab();
        }
        this.untab();
        this.cr();
        this.append("is");
        this.cr();
        this.tab();
        if (toVisit.getVariablesCount() > 0) {
            this.appendTabbed("var");
            this.tab();
            for (VariableDecl variableDecl : toVisit.getVariablesList()) {
                variableDecl.accept(this);
                this.append(";");
            }
            this.untab();
            this.cr();
        }
        if (toVisit.getInitialization() != null) {
            this.appendTabbed("init");
            this.cr();
            this.tab();
            toVisit.getInitialization().accept(this);
            this.untab();
            this.cr();
        }
        for (Transition transition : toVisit.getTransitionsList()) {
            transition.accept(this);
        }
        this.cr();
        this.untab();
    }

    @Override
    public void visitState(State toVisit) {
        this.append(toVisit.getName());
    }

    @Override
    public void visitABCDSystem(ABCDSystem toVisit) {
        this.append("system " + toVisit.getName() + ";\n\n");
        for (Declaration d : toVisit.getDeclarationsList()) {
            d.accept(this);
        }
        if (toVisit.getDeclarationsCount() > 0) {
            this.cr();
        }
        for (ChannelTypeDecl cTD : toVisit.getChannelTypesList()) {
            cTD.accept(this);
        }
        if (toVisit.getChannelTypesCount() > 0) {
            this.cr();
        }
        for (VariableDecl vD : toVisit.getVariablesList()) {
            this.append("var ");
            this.tab();
            vD.accept(this);
            this.cr();
        }
        if (toVisit.getVariablesCount() > 0) {
            this.cr();
        }
        for (ChannelDecl cD : toVisit.getChannelsList()) {
            cD.accept(this);
        }
        if (toVisit.getChannelsCount() > 0) {
            this.cr();
        }
        int i = 0;
        int size = toVisit.getCompositionCount();
        if (size > 0) {
            this.append("par\n");
        }
        this.indentation = 0;
        for (ProcessInstance pI : toVisit.getCompositionList()) {
            if (i == 0) {
                this.tab();
                this.appendTabbed("");
                this.untab();
            }
            pI.accept(this);
            this.cr();
            this.tab();
            if (++i != size) {
                this.appendTabbed("|| ");
            }
            this.untab();
        }
        if (size > 0) {
            this.append("end par\n\n");
        }
        this.indentation = 0;
        for (FunctionDecl fD : toVisit.getFunctionsList()) {
            fD.accept(this);
        }
        this.indentation = 0;
        for (ProcessDecl pD : toVisit.getProcessesList()) {
            pD.accept(this);
        }
    }

    @Override
    public void visitInputStmt(InputStmt toVisit) {
        this.appendTabbed("input ");
        this.append(toVisit.getPort().getName());
        if (toVisit.getExpression() != null) {
            this.append("(");
            toVisit.getExpression().accept(this);
            this.append(")");
        }
    }

    @Override
    public void visitOutputStmt(OutputStmt toVisit) {
        this.appendTabbed("output ");
        this.append(toVisit.getPort().getName());
        if (toVisit.getExpression() != null) {
            this.append("(");
            toVisit.getExpression().accept(this);
            this.append(")");
        }
    }

    @Override
    public void visitToStmt(ToStmt toVisit) {
        this.appendTabbed("to ");
        toVisit.getState().accept(this);
    }

    @Override
    public void visitLoopStmt(LoopStmt toVisit) {
        this.appendTabbed("loop");
    }

    @Override
    public void visitIfStmt(IfStmt toVisit) {
        this.appendTabbed("if ");
        toVisit.getCondition().accept(this);
        this.append(" then\n");
        this.tab();
        toVisit.getTrueBranch().accept(this);
        this.untab();
        if (toVisit.getFalseBranch() != null) {
            this.cr();
            this.appendTabbed("else\n");
            this.tab();
            toVisit.getFalseBranch().accept(this);
            this.untab();
        }
        this.cr();
        this.appendTabbed("end if");
    }

    @Override
    public void visitSelectStmt(SelectStmt toVisit) {
        this.appendTabbed("select");
        this.cr();
        this.tab();
        int sSize = toVisit.getStatementsCount();
        int i = 0;
        for (Statement s : toVisit.getStatementsList()) {
            s.accept(this);
            if (++i == sSize) continue;
            this.cr();
            this.untab();
            this.appendTabbed("[]");
            this.cr();
            this.tab();
        }
        this.cr();
        this.untab();
        this.appendTabbed("end select");
    }

    @Override
    public void visitSpecialTypeStmt(SpecialTypeStmt toVisit) {
        this.appendTabbed("");
        toVisit.getReceiver().accept(this);
        this.append("." + toVisit.getSelector());
        int aSize = toVisit.getArgumentsCount();
        if (aSize > 0) {
            this.append("(");
            int i = 0;
            for (Expression e : toVisit.getArgumentsList()) {
                e.accept(this);
                if (++i == aSize) continue;
                this.append(",");
            }
            this.append(")");
        }
    }

    @Override
    public void visitWaitStmt(WaitStmt toVisit) {
        this.appendTabbed("wait[");
        toVisit.getMinBound().accept(this);
        this.append(", ");
        toVisit.getMaxBound().accept(this);
        this.append("]");
    }

    @Override
    public void visitAssignStmt(AssignStmt toVisit) {
        this.appendTabbed("");
        toVisit.getLhs().accept(this);
        this.append(" := ");
        toVisit.getRhs().accept(this);
    }

    @Override
    public void visitTransition(Transition toVisit) {
        this.cr();
        this.appendTabbed("from ");
        toVisit.getFrom().accept(this);
        this.cr();
        this.tab();
        toVisit.getBehavior().accept(this);
        this.untab();
    }

    @Override
    public void visitBlock(Block toVisit) {
        int stmtSize = toVisit.getStatementsCount();
        for (int i = 0; i < stmtSize; ++i) {
            toVisit.getStatements(i).accept(this);
            this.append(";");
            if (i >= stmtSize - 1) continue;
            this.cr();
        }
    }

    @Override
    public void visitIntegerLit(IntegerLit toVisit) {
        this.sB.append(toVisit.getValue());
    }

    @Override
    public void visitTrueLit(TrueLit toVisit) {
        this.append("true");
    }

    @Override
    public void visitFalseLit(FalseLit toVisit) {
        this.append("false");
    }

    @Override
    public void visitArrayLit(ArrayLit toVisit) {
        this.append("[");
        int size = toVisit.getValueCount();
        int i = 0;
        for (Expression e : toVisit.getValueList()) {
            e.accept(this);
            if (++i == size) continue;
            this.append(", ");
        }
        this.append("]");
    }

    @Override
    public void visitQueueLit(QueueLit toVisit) {
        this.append("{|");
        int size = toVisit.getValueCount();
        int i = 0;
        for (Expression e : toVisit.getValueList()) {
            e.accept(this);
            if (++i == size) continue;
            this.append(", ");
        }
        this.append("|}");
    }

    @Override
    public void visitRecordLit(RecordLit toVisit) {
        this.append("{");
        int size = toVisit.getValueCount();
        int i = 0;
        for (Expression expression : toVisit.getValueList()) {
            expression.accept(this);
            if (++i == size) continue;
            this.append(", ");
        }
        this.append("}");
    }

    @Override
    public void visitFieldLiteral(FieldLiteral toVisit) {
        this.append(toVisit.getName() + "= ");
        toVisit.getValue().accept(this);
    }

    @Override
    public void visitUnaryExp(UnaryExp toVisit) {
        switch (toVisit.getOperator()) {
            case UNOT: {
                this.append("not ");
                break;
            }
            case UMINUS: {
                this.append("-");
            }
        }
        toVisit.getOperand().accept(this);
    }

    @Override
    public void visitBinaryExp(BinaryExp toVisit) {
        this.append("(");
        toVisit.getOperands(0).accept(this);
        switch (toVisit.getOperator()) {
            case BADD: {
                this.append(" + ");
                break;
            }
            case BAND: {
                this.append(" and ");
                break;
            }
            case BDIV: {
                this.append(" / ");
                break;
            }
            case BEQ: {
                this.append(" = ");
                break;
            }
            case BGE: {
                this.append(" >= ");
                break;
            }
            case BGT: {
                this.append(" > ");
                break;
            }
            case BLE: {
                this.append(" <= ");
                break;
            }
            case BLT: {
                this.append(" < ");
                break;
            }
            case BMINUS: {
                this.append(" - ");
                break;
            }
            case BMOD: {
                this.append(" % ");
                break;
            }
            case BMUL: {
                this.append(" * ");
                break;
            }
            case BNAND: {
                this.append(" nand ");
                break;
            }
            case BNE: {
                this.append(" <> ");
                break;
            }
            case BNOR: {
                this.append(" nor ");
                break;
            }
            case BOR: {
                this.append(" or ");
                break;
            }
            case BXOR: {
                this.append(" xor ");
                break;
            }
        }
        toVisit.getOperands(1).accept(this);
        this.append(")");
    }

    @Override
    public void visitIndexedExp(IndexedExp toVisit) {
        toVisit.getPrefix().accept(this);
        this.append("[");
        toVisit.getIndex().accept(this);
        this.append("]");
    }

    @Override
    public void visitSelectedExp(SelectedExp toVisit) {
        toVisit.getPrefix().accept(this);
        this.append("." + toVisit.getSelector());
    }

    @Override
    public void visitReference(Reference toVisit) {
        this.append(toVisit.getRef().getName());
    }

    @Override
    public void visitProcessInstance(ProcessInstance toVisit) {
        int i;
        int iCount = toVisit.getInputsCount();
        int oCount = toVisit.getOutputsCount();
        int aCount = toVisit.getArgumentsCount();
        if (iCount > 0) {
            this.append("[");
            i = 0;
            for (PortMap pM : toVisit.getInputsList()) {
                if (pM.getFormalName() != null) {
                    this.append(pM.getFormalName() + " -- ");
                }
                pM.getActual().accept(this);
                if (++i == iCount) continue;
                this.append(",");
            }
            this.append("]");
        }
        this.append("\t" + toVisit.getName());
        if (aCount > 0) {
            this.append("(");
            i = 0;
            for (ArgumentMap aM : toVisit.getArgumentsList()) {
                if (aM.getFormalName() != null) {
                    this.append(aM.getFormalName() + " -- ");
                }
                aM.getActual().accept(this);
                if (++i == aCount) continue;
                this.append(",");
            }
            this.append(")");
        }
        this.append("\t");
        if (oCount > 0) {
            this.append("[");
            i = 0;
            for (PortMap pM : toVisit.getOutputsList()) {
                if (pM.getFormalName() != null) {
                    this.append(pM.getFormalName() + " -- ");
                }
                pM.getActual().accept(this);
                if (++i == oCount) continue;
                this.append(",");
            }
            this.append("]");
        }
    }

    @Override
    public void visitPortMap(PortMap toVisit) {
    }

    @Override
    public void visitArgumentMap(ArgumentMap argumentMap) {
    }

    @Override
    public void visitParameterDecl(ParameterDecl toVisit) {
        String str = this.visited.get(toVisit);
        if (str != null) {
            this.append(str);
            return;
        }
        this.cr();
        this.appendTabbed(toVisit.getName() + " : ");
        toVisit.getType().accept(this);
        this.visited.put(toVisit, toVisit.getName());
    }

    @Override
    public void visitWhileStmt(WhileStmt toVisit) {
        this.appendTabbed("while ");
        toVisit.getCondition().accept(this);
        this.append(" do ");
        this.cr();
        this.tab();
        toVisit.getBody().accept(this);
        this.untab();
        this.cr();
        this.appendTabbed("end while");
    }

    @Override
    public void visitForeachStmt(ForeachStmt toVisit) {
        this.appendTabbed("foreach ");
        toVisit.getVariable().accept(this);
        this.append(" do ");
        this.cr();
        this.tab();
        toVisit.getBody().accept(this);
        this.untab();
        this.appendTabbed("end foreach");
    }

    @Override
    public void visitNullStmt(NullStmt toVisit) {
        this.appendTabbed("null");
    }

    @Override
    public void visitSendStmt(SendStmt toVisit) {
        this.appendTabbed("send ");
        toVisit.getExpression().accept(this);
        this.append(" to " + toVisit.getPort().getName());
    }

    @Override
    public void visitReceiveStmt(ReceiveStmt toVisit) {
        this.appendTabbed("receive ");
        toVisit.getExpression().accept(this);
        this.append(" from " + toVisit.getPort().getName());
    }

    @Override
    public void visitFunctionDecl(FunctionDecl toVisit) {
        this.append("function " + toVisit.getName());
        this.cr();
        this.tab();
        if (toVisit.getParametersCount() > 0) {
            this.appendTabbed("param");
            this.tab();
            for (ParameterDecl parameterDecl : toVisit.getParametersList()) {
                parameterDecl.accept(this);
                this.append(";");
            }
            this.untab();
        }
        this.cr();
        this.appendTabbed("return ");
        toVisit.getType().accept(this);
        this.untab();
        this.cr();
        this.append("is");
        this.cr();
        this.tab();
        if (toVisit.getVariablesCount() > 0) {
            this.appendTabbed("var");
            this.tab();
            for (VariableDecl variableDecl : toVisit.getVariablesList()) {
                variableDecl.accept(this);
                this.append(";");
            }
            this.untab();
            this.cr();
        }
        toVisit.getBody().accept(this);
        this.cr();
        this.untab();
    }

    @Override
    public void visitReturnStmt(ReturnStmt toVisit) {
        this.appendTabbed("return ");
        toVisit.getExpression().accept(this);
    }

    @Override
    public void visitFunctionCall(FunctionCall toVisit) {
        this.append(toVisit.getFunctionName());
        this.append("(");
        if (toVisit.getArgumentsCount() > 0) {
            int i = 0;
            for (ArgumentMap aM : toVisit.getArgumentsList()) {
                if (aM.getFormalName() != null) {
                    this.append(aM.getFormalName() + " -- ");
                }
                aM.getActual().accept(this);
                if (++i == toVisit.getArgumentsCount()) continue;
                this.append(",");
            }
        }
        this.append(")");
    }

    @Override
    public void visitCaseItem(CaseItem toVisit) {
        this.appendTabbed("");
        toVisit.getExpression().accept(this);
        this.append(" -> ");
        this.cr();
        this.tab();
        toVisit.getBlock().accept(this);
        this.untab();
    }

    @Override
    public void visitCaseStmt(CaseStmt toVisit) {
        this.appendTabbed("case ");
        toVisit.getExpression().accept(this);
        this.append(" of");
        this.cr();
        for (CaseItem c : toVisit.getItemsList()) {
            c.accept(this);
            this.cr();
        }
        this.appendTabbed("end case");
    }

    @Override
    public void visitAny(Any toVisit) {
        this.append("any");
    }

    @Override
    public void visitEventPool(EventPool toVisit) {
        this.append("eventpool buffersize: ");
        toVisit.getSize().accept(this);
    }

    @Override
    public void visitDeferredEvent(DeferredEvent toVisit) {
    }

    @Override
    public void visitGuardStmt(GuardStmt toVisit) {
    }
}

