/*
 * Decompiled with CFR 0.152.
 */
package obp.property;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import obp.cdl.EventReference;
import obp.property.Precedency;
import obp.property.PropertyVisitor;
import org.xid.basics.serializer.Boost;
import org.xid.basics.serializer.BoostObject;
import org.xid.basics.serializer.BoostUtil;

public class PrecedencyExpression
implements BoostObject {
    private Precedency precedency;
    private final List<EventReference> preEventList = new ArrayList<EventReference>();
    private final List<EventReference> postEventList = new ArrayList<EventReference>();

    public PrecedencyExpression() {
    }

    protected PrecedencyExpression(Boost boost) {
        boost.register((BoostObject)this);
        this.precedency = (Precedency)boost.readEnum(Precedency.class);
        for (EventReference oneChild : BoostUtil.readObjectList((Boost)boost, EventReference.class)) {
            this.preEventList.add(oneChild);
        }
        for (EventReference oneChild : BoostUtil.readObjectList((Boost)boost, EventReference.class)) {
            this.postEventList.add(oneChild);
        }
    }

    public Precedency getPrecedency() {
        return this.precedency;
    }

    public void setPrecedency(Precedency newValue) {
        if (this.precedency == null ? newValue != null : !this.precedency.equals((Object)newValue)) {
            this.precedency = newValue;
        }
    }

    public List<EventReference> getPreEventList() {
        return Collections.unmodifiableList(this.preEventList);
    }

    public int getPreEventCount() {
        return this.preEventList.size();
    }

    public EventReference getPreEvent(int index) {
        if (index < 0 || index >= this.getPreEventCount()) {
            return null;
        }
        return this.preEventList.get(index);
    }

    public void addPreEvent(EventReference newValue) {
        this.addPreEvent(this.getPreEventCount(), newValue);
    }

    public void addPreEvent(int index, EventReference newValue) {
        this.preEventList.add(index, newValue);
    }

    public EventReference setPreEvent(int index, EventReference newValue) {
        return this.preEventList.set(index, newValue);
    }

    public void addAllPreEvent(Collection<EventReference> toAddList) {
        for (EventReference newValue : toAddList) {
            this.addPreEvent(this.getPreEventCount(), newValue);
        }
    }

    public void removePreEvent(EventReference value) {
        int index = this.preEventList.indexOf(value);
        if (index >= 0) {
            this.removePreEvent(index);
        }
    }

    public void removePreEvent(int index) {
        this.preEventList.remove(index);
    }

    public List<EventReference> getPostEventList() {
        return Collections.unmodifiableList(this.postEventList);
    }

    public int getPostEventCount() {
        return this.postEventList.size();
    }

    public EventReference getPostEvent(int index) {
        if (index < 0 || index >= this.getPostEventCount()) {
            return null;
        }
        return this.postEventList.get(index);
    }

    public void addPostEvent(EventReference newValue) {
        this.addPostEvent(this.getPostEventCount(), newValue);
    }

    public void addPostEvent(int index, EventReference newValue) {
        this.postEventList.add(index, newValue);
    }

    public EventReference setPostEvent(int index, EventReference newValue) {
        return this.postEventList.set(index, newValue);
    }

    public void addAllPostEvent(Collection<EventReference> toAddList) {
        for (EventReference newValue : toAddList) {
            this.addPostEvent(this.getPostEventCount(), newValue);
        }
    }

    public void removePostEvent(EventReference value) {
        int index = this.postEventList.indexOf(value);
        if (index >= 0) {
            this.removePostEvent(index);
        }
    }

    public void removePostEvent(int index) {
        this.postEventList.remove(index);
    }

    public void writeToBoost(Boost boost) {
        boost.writeEnum((Enum)this.precedency);
        BoostUtil.writeObjectCollection((Boost)boost, this.preEventList);
        BoostUtil.writeObjectCollection((Boost)boost, this.postEventList);
    }

    public void accept(PropertyVisitor visitor) {
        visitor.visitPrecedencyExpression(this);
    }
}

