/*
 * Decompiled with CFR 0.152.
 */
package fr.ensta.aefd.runtime;

import fr.ensta.aefd.model.AEFDAction;
import fr.ensta.aefd.model.AEFDActionSequence;
import fr.ensta.aefd.model.AEFDAutomate;
import fr.ensta.aefd.model.AEFDBooleanExpression;
import fr.ensta.aefd.model.AEFDBooleanVariable;
import fr.ensta.aefd.model.AEFDEvent;
import fr.ensta.aefd.model.AEFDFunctionalEntity;
import fr.ensta.aefd.model.AEFDModel;
import fr.ensta.aefd.model.AEFDModelVisitor;
import fr.ensta.aefd.model.AEFDTransition;
import fr.ensta.aefd.runtime.AEFDRuntimeInfos;
import fr.ensta.aefd.runtime.HelperIndexer;
import java.util.HashMap;
import java.util.Map;

public class AEFDRuntimeInfosImpl
extends AEFDModelVisitor.Stub
implements AEFDRuntimeInfos {
    private final HelperIndexer<AEFDBooleanVariable> variableIndexer = new HelperIndexer();
    private final HelperIndexer<AEFDAutomate> automateIndexer = new HelperIndexer();
    private final Map<AEFDAutomate, HelperIndexer<String>> automateStateIndexerMap = new HashMap<AEFDAutomate, HelperIndexer<String>>();
    private final HelperIndexer<AEFDFunctionalEntity> eventIndexer = new HelperIndexer();
    private final Map<AEFDTransition, AEFDAutomate> transitionMap = new HashMap<AEFDTransition, AEFDAutomate>();
    private AEFDAutomate currentAutomate;

    public AEFDRuntimeInfosImpl(AEFDModel model) {
        this.initializeVariables(model);
        this.visitAutomates(model);
    }

    private void initializeVariables(AEFDModel model) {
        for (AEFDBooleanVariable variable : model.getAllVariables()) {
            this.variableIndexer.addElement(variable);
        }
        AEFDBooleanVariable[] variableArray = new AEFDBooleanVariable[this.variableIndexer.getNumberOfElements()];
        this.variableIndexer.setAndFillElementArray((AEFDBooleanVariable[])variableArray);
    }

    private void visitAutomates(AEFDModel model) {
        for (AEFDAutomate automate : model.getAllAutomates()) {
            automate.accept((AEFDModelVisitor)this);
        }
        this.currentAutomate = null;
        AEFDAutomate[] automateArray = new AEFDAutomate[this.automateIndexer.getNumberOfElements()];
        this.automateIndexer.setAndFillElementArray((AEFDAutomate[])automateArray);
        AEFDFunctionalEntity[] eventArray = new AEFDFunctionalEntity[this.eventIndexer.getNumberOfElements()];
        this.eventIndexer.setAndFillElementArray((AEFDFunctionalEntity[])eventArray);
    }

    public void visitAutomate(AEFDAutomate automate) {
        this.currentAutomate = automate;
        this.automateIndexer.addElement(automate);
        HelperIndexer<String> currentAutomateStateIndexer = new HelperIndexer<String>();
        this.automateStateIndexerMap.put(automate, currentAutomateStateIndexer);
        for (String place : automate.getPlaceSet()) {
            currentAutomateStateIndexer.addElement(place);
        }
        String[] automateStateArray = new String[currentAutomateStateIndexer.getNumberOfElements()];
        currentAutomateStateIndexer.setAndFillElementArray(automateStateArray);
        for (AEFDTransition transition : automate.getTransitionSet()) {
            transition.accept((AEFDModelVisitor)this);
            transition.getAction().accept((AEFDModelVisitor)this);
        }
    }

    public void visitTransition(AEFDTransition transition) {
        this.transitionMap.put(transition, this.currentAutomate);
        transition.getEvent().accept((AEFDModelVisitor)this);
    }

    public void visitEvent(AEFDEvent event) {
        event.getBoolExp().accept((AEFDBooleanExpression.Visitor)this);
    }

    public void visitTrigger(AEFDBooleanExpression.Trigger trigger) {
        this.eventIndexer.addElement(trigger.getFunctionalEntity());
    }

    public void visitNot(AEFDBooleanExpression.Not not) {
        throw new IllegalStateException("Operator 'not' unexpected within event expression");
    }

    public void visitOr(AEFDBooleanExpression.Or or) {
        or.getLhs().accept((AEFDBooleanExpression.Visitor)this);
        or.getRhs().accept((AEFDBooleanExpression.Visitor)this);
    }

    public void visitAnd(AEFDBooleanExpression.And and) {
        throw new IllegalStateException("Operator 'and' unexpected within event expression");
    }

    public void visitActionSequence(AEFDActionSequence actionSequence) {
        for (AEFDAction action : actionSequence.getActionList()) {
            action.accept((AEFDModelVisitor)this);
        }
    }

    public void visitSendEvent(AEFDAction.SendEvent sendEvent) {
        this.eventIndexer.addElement(sendEvent.getFunctionalEntity());
    }

    @Override
    public AEFDFunctionalEntity getEventFromIndex(int index) {
        return this.eventIndexer.getElementArray()[index];
    }

    @Override
    public int getEventIndex(AEFDFunctionalEntity functionalEntity) {
        return this.eventIndexer.getIndexMap().get(functionalEntity);
    }

    @Override
    public int getNumberOfEvents() {
        return this.eventIndexer.getNumberOfElements();
    }

    @Override
    public AEFDBooleanVariable getVariableFromIndex(int index) {
        return this.variableIndexer.getElementArray()[index];
    }

    @Override
    public int getVariableIndex(AEFDBooleanVariable variable) {
        return this.variableIndexer.getIndexMap().get(variable);
    }

    @Override
    public int getNumberOfVariables() {
        return this.variableIndexer.getNumberOfElements();
    }

    @Override
    public AEFDAutomate getAutomateFromIndex(int index) {
        return this.automateIndexer.getElementArray()[index];
    }

    @Override
    public int getAutomateIndex(AEFDAutomate automate) {
        return this.automateIndexer.getIndexMap().get(automate);
    }

    @Override
    public int getNumberOfAutomates() {
        return this.automateIndexer.getNumberOfElements();
    }

    @Override
    public String getAutomateStateFromIndex(AEFDAutomate automate, int index) {
        return this.automateStateIndexerMap.get(automate).getElementArray()[index];
    }

    @Override
    public int getAutomateStateIndex(AEFDAutomate automate, String state) {
        return this.automateStateIndexerMap.get(automate).getIndexMap().get(state);
    }

    @Override
    public int getNumberOfStates(AEFDAutomate automate) {
        return this.automateStateIndexerMap.get(automate).getNumberOfElements();
    }

    @Override
    public AEFDAutomate getTransitionOwner(AEFDTransition transition) {
        return this.transitionMap.get(transition);
    }
}

