/*
 * Decompiled with CFR 0.152.
 */
package obp2.language.state_event.diagnosis.dsl.model;

import obp2.language.state_event.diagnosis.dsl.DiagnosisModelVisitor;
import obp2.language.state_event.diagnosis.dsl.model.DiagnosisExp;
import obp2.language.state_event.diagnosis.dsl.model.Type;

public class UnaryExp
extends DiagnosisExp {
    DiagnosisExp operand;
    Operator operator;

    public DiagnosisExp getOperand() {
        return this.operand;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public UnaryExp(Operator operator, DiagnosisExp operand) {
        this.operator = operator;
        this.operand = operand;
    }

    @Override
    public Type getType() {
        if (this.type == null || this.type == Type.UNKNOWN) {
            Type oT = this.operand.getType();
            switch (this.operator) {
                case NOT: {
                    if (oT != Type.BOOLEAN) {
                        throw new RuntimeException("NOT expects Boolean operand");
                    }
                    this.type = Type.BOOLEAN;
                    break;
                }
                case MINUS: {
                    if (oT != Type.NUMBER) {
                        throw new RuntimeException("MINUS expects Boolean operand");
                    }
                    this.type = Type.NUMBER;
                }
            }
        }
        return this.type;
    }

    @Override
    public <T> T accept(DiagnosisModelVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public static enum Operator {
        NOT,
        MINUS;

    }
}

