/*
 * Decompiled with CFR 0.152.
 */
package obp2.language.state_event.diagnosis.dsl.evaluator;

import obp2.language.state_event.diagnosis.dsl.DiagnosisModelVisitor;
import obp2.language.state_event.diagnosis.dsl.evaluator.BooleanValue;
import obp2.language.state_event.diagnosis.dsl.evaluator.EvaluationEnvironment;
import obp2.language.state_event.diagnosis.dsl.evaluator.Linker;
import obp2.language.state_event.diagnosis.dsl.evaluator.NumberValue;
import obp2.language.state_event.diagnosis.dsl.evaluator.Value;
import obp2.language.state_event.diagnosis.dsl.model.BinaryExp;
import obp2.language.state_event.diagnosis.dsl.model.ClockRef;
import obp2.language.state_event.diagnosis.dsl.model.ConditionalExp;
import obp2.language.state_event.diagnosis.dsl.model.DiagnosisExp;
import obp2.language.state_event.diagnosis.dsl.model.LiteralExp;
import obp2.language.state_event.diagnosis.dsl.model.NextVariableRef;
import obp2.language.state_event.diagnosis.dsl.model.TransitionRef;
import obp2.language.state_event.diagnosis.dsl.model.UnaryExp;
import obp2.language.state_event.diagnosis.dsl.model.VariableRef;
import obp2.language.state_event.model.StateEventModel;

public class SEDiagnosisEvaluator
implements DiagnosisModelVisitor<Value> {
    EvaluationEnvironment environment;

    public boolean evaluate(DiagnosisExp expression, StateEventModel model, EvaluationEnvironment environment) {
        Linker linker = new Linker();
        linker.link(expression, model);
        environment.setModel(model);
        return this.evaluate(expression, environment);
    }

    public boolean evaluate(DiagnosisExp expression, EvaluationEnvironment environment) {
        this.environment = environment;
        return (Boolean)expression.accept(this).getValue();
    }

    @Override
    public Value visit(LiteralExp expr) {
        return new NumberValue(expr.getValue());
    }

    @Override
    public Value visit(ClockRef expr) {
        if (this.environment.fireable == null) {
            throw new RuntimeException("clock expressions are supported only by the State-Event solvers");
        }
        if (expr.getIndex() == -1) {
            return BooleanValue.ff;
        }
        for (int clki : this.environment.fireable.events) {
            if (clki != expr.getIndex()) continue;
            return BooleanValue.tt;
        }
        return BooleanValue.ff;
    }

    @Override
    public Value visit(TransitionRef expr) {
        if (this.environment.fireable == null) {
            throw new RuntimeException("transition expressions are supported only by the State-Event solvers");
        }
        return this.environment.fireable.id == expr.getIndex() ? BooleanValue.tt : BooleanValue.ff;
    }

    @Override
    public Value visit(VariableRef expr) {
        return new NumberValue(this.environment.source.values[expr.getIndex()]);
    }

    @Override
    public Value visit(NextVariableRef expr) {
        if (this.environment.target == null) {
            throw new RuntimeException("next-state expressions are supported only by the State-Event solvers");
        }
        return new NumberValue(this.environment.target.values[expr.getIndex()]);
    }

    @Override
    public Value visit(UnaryExp expr) {
        switch (expr.getOperator()) {
            case NOT: {
                return expr.getOperand().accept(this).getValue() == BooleanValue.tt ? BooleanValue.ff : BooleanValue.tt;
            }
            case MINUS: {
                return new NumberValue(-((Integer)expr.getOperand().accept(this).getValue()).intValue());
            }
        }
        return null;
    }

    @Override
    public Value visit(BinaryExp expr) {
        Value lhsV = expr.getLhs().accept(this);
        Value rhsV = expr.getRhs().accept(this);
        switch (expr.getOperator()) {
            case MULT: {
                int lhs = (Integer)lhsV.getValue();
                int rhs = (Integer)rhsV.getValue();
                return new NumberValue(lhs * rhs);
            }
            case MOD: {
                int lhs = (Integer)lhsV.getValue();
                int rhs = (Integer)rhsV.getValue();
                return new NumberValue(lhs % rhs);
            }
            case PLUS: {
                int lhs = (Integer)lhsV.getValue();
                int rhs = (Integer)rhsV.getValue();
                return new NumberValue(lhs + rhs);
            }
            case MINUS: {
                int lhs = (Integer)lhsV.getValue();
                int rhs = (Integer)rhsV.getValue();
                return new NumberValue(lhs - rhs);
            }
            case LT: {
                int lhs = (Integer)lhsV.getValue();
                int rhs = (Integer)rhsV.getValue();
                return lhs < rhs ? BooleanValue.tt : BooleanValue.ff;
            }
            case LTE: {
                int lhs = (Integer)lhsV.getValue();
                int rhs = (Integer)rhsV.getValue();
                return lhs <= rhs ? BooleanValue.tt : BooleanValue.ff;
            }
            case GT: {
                int lhs = (Integer)lhsV.getValue();
                int rhs = (Integer)rhsV.getValue();
                return lhs > rhs ? BooleanValue.tt : BooleanValue.ff;
            }
            case GTE: {
                int lhs = (Integer)lhsV.getValue();
                int rhs = (Integer)rhsV.getValue();
                return lhs >= rhs ? BooleanValue.tt : BooleanValue.ff;
            }
            case EQ: {
                return lhsV.getValue() == rhsV.getValue() ? BooleanValue.tt : BooleanValue.ff;
            }
            case NEQ: {
                return lhsV.getValue() == rhsV.getValue() ? BooleanValue.ff : BooleanValue.tt;
            }
        }
        return null;
    }

    @Override
    public Value visit(ConditionalExp expr) {
        BooleanValue condition = (BooleanValue)expr.getCondition().accept(this).getValue();
        if (condition == BooleanValue.tt) {
            return expr.getTrueBranch().accept(this);
        }
        return expr.getFalseBranch().accept(this);
    }
}

