/*
 * Decompiled with CFR 0.152.
 */
package obp2.simulation.trace_storage;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import obp2.simulation.trace_storage.TraceEntry;
import plug.utils.Pair;

public class TraceStore<C, A, O> {
    private boolean hasCounterExample = false;
    CountDownLatch latch;
    Set<TraceEntry<C, A, O>> roots = new HashSet<TraceEntry<C, A, O>>();
    TraceEntry<C, A, O> lastEntry;
    Consumer<TraceEntry<C, A, O>> addRootUserCallback;
    Consumer<TraceEntry<C, A, O>> addStepUserCallback;

    public TraceStore() {
        this.latch = new CountDownLatch(1);
    }

    public boolean hasCounterExample() throws InterruptedException {
        this.latch.await();
        return this.hasCounterExample;
    }

    public void setHasCounterExample() {
        this.hasCounterExample = true;
        this.latch.countDown();
    }

    public void noCounterExample() {
        this.latch.countDown();
    }

    public void setAddRootUserCallback(Consumer<TraceEntry<C, A, O>> addRootUserCallback) {
        this.addRootUserCallback = addRootUserCallback;
    }

    public void setAddStepUserCallback(Consumer<TraceEntry<C, A, O>> addStepUserCallback) {
        this.addStepUserCallback = addStepUserCallback;
    }

    public TraceEntry<C, A, O> getLastEntry() {
        return this.lastEntry;
    }

    public TraceEntry<C, A, O> addRoot(C rootEntry) {
        if (rootEntry == null) {
            return null;
        }
        TraceEntry entry = new TraceEntry(rootEntry);
        this.roots.add(entry);
        if (this.addRootUserCallback != null) {
            this.addRootUserCallback.accept(entry);
        }
        this.lastEntry = entry;
        return entry;
    }

    public void addRoots(Collection<C> rootEntries) {
        rootEntries.forEach(this::addRoot);
    }

    public Collection<TraceEntry<C, A, O>> getRoots() {
        return this.roots;
    }

    public TraceEntry<C, A, O> addStep(TraceEntry<C, A, O> sourceEntry, C target, Pair<A, O> transition) {
        if (target == null) {
            return null;
        }
        TraceEntry<C, A, O> targetEntry = new TraceEntry<C, A, O>(sourceEntry, target, transition);
        if (sourceEntry == null) {
            this.roots.add(targetEntry);
        }
        if (this.addStepUserCallback != null) {
            this.addStepUserCallback.accept(targetEntry);
        }
        this.lastEntry = targetEntry;
        return targetEntry;
    }

    public TraceEntry<C, A, O> addStep(TraceEntry<C, A, O> sourceEntry, C target, A action, O output) {
        return this.addStep(sourceEntry, target, action, output);
    }

    public TraceEntry<C, A, O> addSteps(TraceEntry<C, A, O> potentialSource, List<C> followingSteps, BiFunction<C, C, Pair<A, O>> actionsProvider) {
        if (potentialSource == null) {
            return this.addSteps(Collections.emptyList(), followingSteps, actionsProvider);
        }
        return this.addSteps(Collections.singleton(potentialSource), followingSteps, actionsProvider);
    }

    public TraceEntry<C, A, O> addSteps(Collection<TraceEntry<C, A, O>> potentialSources, List<C> followingSteps, BiFunction<C, C, Pair<A, O>> actionsProvider) {
        if (followingSteps == null || followingSteps.isEmpty()) {
            return null;
        }
        C firstC = followingSteps.get(0);
        TraceEntry<C, A, O> initial = null;
        initial = this.getAMatchingTraceEntry(this.roots, firstC);
        if (initial == null) {
            initial = this.getAMatchingTraceEntry(potentialSources, firstC);
        }
        if (initial == null) {
            initial = this.addRoot(firstC);
        }
        TraceEntry<C, A, O> previous = initial;
        for (int i = 1; i < followingSteps.size(); ++i) {
            C current = followingSteps.get(i);
            previous = this.addStep(previous, current, actionsProvider.apply(previous.getConfiguration(), current));
        }
        return previous;
    }

    TraceEntry<C, A, O> getAMatchingTraceEntry(Collection<TraceEntry<C, A, O>> collection, C target) {
        for (TraceEntry<C, A, O> traceEntry : collection) {
            if (!traceEntry.getConfiguration().equals(target)) continue;
            return traceEntry;
        }
        return null;
    }

    public void iterateOverTrace() {
        for (TraceEntry<C, A, O> root : this.roots) {
            this.dfs(root);
        }
    }

    void dfs(TraceEntry<C, A, O> entry) {
        if (entry.getParent() == null) {
            if (this.addRootUserCallback != null) {
                this.addRootUserCallback.accept(entry);
            }
        } else if (this.addStepUserCallback != null) {
            this.addStepUserCallback.accept(entry);
        }
        for (TraceEntry<C, A, O> child : entry.getChildren()) {
            this.dfs(child);
        }
    }
}

