/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.liveness;

import tlc2.tool.TLCState;
import tlc2.tool.Tool;
import tlc2.tool.liveness.LiveExprNode;

class LNBool
extends LiveExprNode {
    public static final LNBool TRUE = new LNBool(true);
    public static final LNBool FALSE = new LNBool(false);
    protected final boolean b;

    public LNBool(boolean b) {
        this.b = b;
    }

    @Override
    public final boolean eval(Tool tool, TLCState s1, TLCState s2) {
        return this.b;
    }

    @Override
    public final int getLevel() {
        return 0;
    }

    @Override
    public final boolean containAction() {
        return false;
    }

    @Override
    public final void toString(StringBuffer sb, String padding) {
        sb.append(this.b ? "TRUE" : "FALSE");
    }

    @Override
    public LiveExprNode pushNeg() {
        return new LNBool(!this.b);
    }

    @Override
    public LiveExprNode pushNeg(boolean hasNeg) {
        if (hasNeg) {
            return new LNBool(!this.b);
        }
        return super.pushNeg(hasNeg);
    }

    @Override
    public boolean equals(LiveExprNode exp) {
        if (exp instanceof LNBool) {
            return this.b == ((LNBool)exp).b;
        }
        return false;
    }
}

