/*
 * Decompiled with CFR 0.152.
 */
package plug.language.TLA;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import plug.core.IRuntimeView;
import plug.core.view.ConfigurationItem;
import plug.language.TLA.runtime.TLAConfiguration;
import plug.language.TLA.runtime.TLATransitionRelation;
import plug.utils.Pair;
import tlc2.tool.Action;
import tlc2.tool.StateVec;
import tlc2.value.BoolValue;
import tlc2.value.FcnRcdValue;
import tlc2.value.IntValue;
import tlc2.value.ModelValue;
import tlc2.value.RecordValue;
import tlc2.value.SetEnumValue;
import tlc2.value.StringValue;
import tlc2.value.TupleValue;
import tlc2.value.UndefValue;
import tlc2.value.Value;
import util.UniqueString;

public class TLARuntimeView
implements IRuntimeView<TLAConfiguration, Pair<Action, StateVec>> {
    TLATransitionRelation runtime;

    public TLARuntimeView(TLATransitionRelation runtime) {
        this.runtime = runtime;
    }

    public TLATransitionRelation getRuntime() {
        return this.runtime;
    }

    public List<ConfigurationItem> getConfigurationItems(TLAConfiguration value) {
        ArrayList<ConfigurationItem> children = new ArrayList<ConfigurationItem>();
        for (Map.Entry item : value.getState().getVals().entrySet()) {
            children.add(this.getConfigurationItem((UniqueString)item.getKey(), (Value)item.getValue()));
        }
        return children;
    }

    String getSimpleName(UniqueString name, Value value, String separator) {
        return (name == null ? "" : name + separator) + value;
    }

    ConfigurationItem getConfigurationItem(UniqueString name, Value value) {
        if (value instanceof FcnRcdValue) {
            return this.getConfigurationItem(name, (FcnRcdValue)value);
        }
        if (value instanceof SetEnumValue) {
            return this.getConfigurationItem(name, (SetEnumValue)value);
        }
        if (value instanceof RecordValue) {
            return this.getConfigurationItem(name, (RecordValue)value);
        }
        if (value instanceof TupleValue) {
            return this.getConfigurationItem(name, (TupleValue)value);
        }
        if (value instanceof IntValue || value instanceof BoolValue || value instanceof StringValue || value instanceof UndefValue || value instanceof ModelValue) {
            return new ConfigurationItem("entry", this.getSimpleName(name, value, " = "), null, null);
        }
        return new ConfigurationItem("entry", this.getSimpleName(name, value, " = "), null, null);
    }

    ConfigurationItem getConfigurationItem(UniqueString name, TupleValue value) {
        ArrayList<ConfigurationItem> items = new ArrayList<ConfigurationItem>();
        for (int i = 0; i < value.elems.length; ++i) {
            items.add(this.getConfigurationItem(null, value.elems[i]));
        }
        return new ConfigurationItem("tuple", this.getSimpleName(name, (Value)value, " = "), null, items);
    }

    ConfigurationItem getConfigurationItem(UniqueString name, RecordValue value) {
        ArrayList<ConfigurationItem> items = new ArrayList<ConfigurationItem>();
        for (int i = 0; i < value.names.length; ++i) {
            items.add(this.getConfigurationItem(value.names[i], value.values[i]));
        }
        return new ConfigurationItem("setenum", this.getSimpleName(name, (Value)value, " = "), null, items);
    }

    ConfigurationItem getConfigurationItem(UniqueString name, SetEnumValue value) {
        if (!value.isNormalized()) {
            value.normalize();
        }
        ArrayList<ConfigurationItem> items = new ArrayList<ConfigurationItem>();
        for (int i = 0; i < value.elems.size(); ++i) {
            items.add(this.getConfigurationItem(null, value.elems.elementAt(i)));
        }
        return new ConfigurationItem("setenum", this.getSimpleName(name, (Value)value, " = "), null, items);
    }

    ConfigurationItem getConfigurationItem(UniqueString name, FcnRcdValue value) {
        if (value.values.length == 0) {
            return new ConfigurationItem("entry", name + " = << >>", null, null);
        }
        Method isRcd = null;
        Method isTuple = null;
        for (Method method : value.getClass().getDeclaredMethods()) {
            if (method.getName().equals("isRcd")) {
                method.setAccessible(true);
                isRcd = method;
            }
            if (!method.getName().equals("isTuple")) continue;
            method.setAccessible(true);
            isTuple = method;
        }
        try {
            if (isRcd != null && isTuple != null) {
                int i;
                ArrayList<ConfigurationItem> items = new ArrayList<ConfigurationItem>();
                if (((Boolean)isRcd.invoke((Object)value, new Object[0])).booleanValue()) {
                    for (i = 0; i < value.values.length; ++i) {
                        items.add(new ConfigurationItem("recordItem", ((StringValue)value.domain[0]).val + " |-> " + value.values[i], null, Collections.singletonList(this.getConfigurationItem(((StringValue)value.domain[0]).val, value.values[i]))));
                    }
                    return new ConfigurationItem("record", this.getSimpleName(name, (Value)value, " = "), null, items);
                }
                if (((Boolean)isTuple.invoke((Object)value, new Object[0])).booleanValue()) {
                    for (i = 0; i < value.values.length; ++i) {
                        items.add(new ConfigurationItem("tupleItem", value.values[i].toString(), null, Collections.singletonList(this.getConfigurationItem(null, value.values[i]))));
                    }
                    return new ConfigurationItem("tuple", this.getSimpleName(name, (Value)value, " = "), null, items);
                }
                for (i = 0; i < value.values.length; ++i) {
                    items.add(new ConfigurationItem("array", value.domain[0] + " :> " + value.values[i], null, Collections.singletonList(this.getConfigurationItem(null, value.values[i]))));
                }
                return new ConfigurationItem("array", this.getSimpleName(name, (Value)value, " = "), null, items);
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return this.getConfigurationItem(name, (Value)value);
    }
}

